<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سند استلام</title>
    
<style>
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgb(0 0 0 / 15%);
            font-size: 16px;
            line-height: 24px;
            font-family: 'Cairo', sans-serif;
            color: #555;
            text-align: right;
        }

        .top {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            font-size: 20px;
            font-weight: bold;
            padding-bottom: 20px;
            border-bottom: 4px solid #193B62;
        }

        .top span:nth-child(1) {
            display: block;
        }

        .top .right {
            display: flex;
            align-items: center;
            flex-direction: column;
            align-content: center;
        }

        .top .center {
            display: flex;
            align-items: center;

        }

        .information {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: center;
            margin-top: 20px;
            padding-left: 50px;
            padding-right: 50px;
        }



        .information .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information-main {

            margin-top: 30px;
            padding-left: 90px;
            padding-right: 90px;
        }



        .information-main .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information-main .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .left span:nth-child(1) {
            display: block;
        }

        .left span:nth-child(2) {
            display: block;
        }

        span {
            margin-right: 8px;
            font-weight: 500;
        }

        .bold {
            font-weight: bold;
        }

        .botom {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 40px;
            padding-left: 20px;
            padding-right: 20px;

        }


        .seg2 {
            display: flex;
            flex-direction: row-reverse;
            justify-content: space-between;
        }

        .botom .seg {
            display: flex;
            flex-direction: column;
            align-content: center;

        }

        .botom .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 10px;
            padding-left: 20px;
            padding-right: 20px;
            margin-bottom: 40px;
        }



        .botom-seg .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .botom-seg .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .top-text {
            display: flex;
            margin-bottom: 20px;
            flex-direction: row-reverse;
        }

        .botom-text {
            display: flex;

            flex-direction: row-reverse;
        }

        table,
        th,
        td {
            border: 1px solid black;
            border-collapse: collapse;
            direction: rtl;
            padding: 10px;
            text-align: center;
            margin-top: 20px;
        }

        @media print {
            .invoice-box {
                max-width: unset;
                box-shadow: none;
                border: 0px;
            }
        }

        @page {
            size: A5 landscape
        }
    </style>
</head>

<body>
  <div class="invoice-box">
    <div class="top">
        <div class="right">
            <span>الجمهورية اليمنية</span>
            <span>صنعاء شارع الستين</span>
            <span>+967 773344551</span>
        </div>
        <div class="center">
            <img width="200" src="<?php echo e(asset('/images/logo-full.png')); ?>" alt="">

        </div>
        <div class="left">
            <span class="">رقم السند :
                <?php if(isset($recept->id)): ?>
                    <?php echo e($recept->id); ?>

                <?php endif; ?></span>
                <span class="">التاريخ :
                    <?php if(isset($recept->created_at)): ?>
                        <?php echo e(explode(' ',$recept->created_at)[0]); ?>

                    <?php endif; ?></span>
        </div>
    </div>

        <div class="information">

            <div class="center">
                <span class="bold">سند استلام القسائم</span>

            </div>

        </div>



        <div class="table">
            <table style="width: 100%;">
                <tr>
                    <th>عدد القسائم</th>
                    <th>من رقم</th>
                    <th>إلى رقم</th>
                    <th>الكمية في كل قسيمة</th>
                    <th>الإجمالي</th>
                    <th>النوع</th>
                </tr>
                <?php for($i = 0; $i < $count; $i++): ?>
                    <tr>
                        <td><?php if(isset($numberOfCoupons[$i])): ?>
                        <?php echo e($numberOfCoupons[$i]); ?>

                        <?php endif; ?></td>
                        <td><?php if(isset($from[$i])): ?>
                        <?php echo e($from[$i]); ?>

                        <?php endif; ?></td>
                        <td><?php if(isset($to[$i])): ?>
                        <?php echo e($to[$i]); ?>

                        <?php endif; ?></td>
                        <td><?php if(isset($quantityInCoupon[$i])): ?>
                        <?php echo e($quantityInCoupon[$i]); ?>

                        <?php endif; ?> لتر</td>
                        <td><?php if(isset($quantity[$i])): ?>
                      <?php echo e($quantity[$i]); ?>

                    <?php endif; ?> لتر</td>
                    <td>
                      <?php if(isset($type[$i])): ?>
                          <?php echo e($type[$i]); ?>

                      <?php endif; ?>
                    </td>
                </tr>

                <?php endfor; ?>
                
            </table>

            <h4>اجمالي البترول : <?php echo e($quantityOfPetrol); ?> لتر</h4>
            <h4>اجمالي الديزل : <?php echo e($quantityOfDiesel); ?> لتر</h4>

        </div>
        <div class="botom">

            <div class="seg">
                <div class="top-text">
                    <span class="bold">: العميل</span>
                    <span><?php if(isset($niceName)): ?> <?php echo e($niceName); ?> <?php endif; ?></span>
                </div>
                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المحاسب</span>
                    <span><?php if(isset($accountancy->name)): ?> <?php echo e($accountancy->name); ?> <?php endif; ?> </span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المدير</span>
                    <span><?php if(isset($manager->name)): ?> <?php echo e($manager->name); ?> <?php endif; ?></span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
        </div>




    </div>

</body>


</html>
<?php /**PATH C:\Users\Nasser\Desktop\petrol_store\resources\views/invoices/printspentCouponsToClint.blade.php ENDPATH**/ ?>